#ifndef __SERCOSIII_MA_CP_ERROR_H
#define __SERCOSIII_MA_CP_ERROR_H




/////////////////////////////////////////////////////////////////////////////////////
// Sercos III - Result and Status Codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_SIII_MA_CP_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command value.
//
#define TLR_E_SIII_MA_CP_COMMAND_INVALID ((TLR_RESULT)0xC0700001L)

//
// MessageId: TLR_E_SIII_MA_CP_INVALID_STARTUP_PARAMETER
//
// MessageText:
//
//  Invalid Startup parameter.
//
#define TLR_E_SIII_MA_CP_INVALID_STARTUP_PARAMETER ((TLR_RESULT)0xC0700002L)

//
// MessageId: TLR_E_SIII_MA_CP_WAITING_FOR_TOPOLOGY_DETECT
//
// MessageText:
//
//  Waiting for Topology Detect (CP0).
//
#define TLR_E_SIII_MA_CP_WAITING_FOR_TOPOLOGY_DETECT ((TLR_RESULT)0xC0700003L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_NOT_STARTED
//
// MessageText:
//
//  SercosIII Low Level Driver not started.
//
#define TLR_E_SIII_MA_CP_LLD_NOT_STARTED ((TLR_RESULT)0xC0700004L)

//
// MessageId: TLR_E_SIII_MA_CP_INIT_CALLBACK_HP_FAILED
//
// MessageText:
//
//  Initialization of HP Callback failed.
//
#define TLR_E_SIII_MA_CP_INIT_CALLBACK_HP_FAILED ((TLR_RESULT)0xC0700005L)

//
// MessageId: TLR_E_SIII_MA_CP_INIT_CALLBACK_DEVSTATUS_FAILED
//
// MessageText:
//
//  Initialization of DevStatus Callback failed.
//
#define TLR_E_SIII_MA_CP_INIT_CALLBACK_DEVSTATUS_FAILED ((TLR_RESULT)0xC0700006L)

//
// MessageId: TLR_E_SIII_MA_CP_INIT_CALLBACK_TOPOLOGY_DETECT_FAILED
//
// MessageText:
//
//  Initialization of Topology Detect Callback failed.
//
#define TLR_E_SIII_MA_CP_INIT_CALLBACK_TOPOLOGY_DETECT_FAILED ((TLR_RESULT)0xC0700007L)

//
// MessageId: TLR_E_SIII_MA_CP_CONFIGURATION_BUFFER_ALREADY_OPEN
//
// MessageText:
//
//  Configuration Buffer is already open.
//
#define TLR_E_SIII_MA_CP_CONFIGURATION_BUFFER_ALREADY_OPEN ((TLR_RESULT)0xC0700008L)

//
// MessageId: TLR_E_SIII_MA_CP_CONFIGURATION_BUFFER_IS_NOT_OPEN
//
// MessageText:
//
//  Configuration Buffer is not open.
//
#define TLR_E_SIII_MA_CP_CONFIGURATION_BUFFER_IS_NOT_OPEN ((TLR_RESULT)0xC0700009L)

//
// MessageId: TLR_E_SIII_MA_CP_INVALID_SLAVE_ADDRESS
//
// MessageText:
//
//  Invalid slave address.
//
#define TLR_E_SIII_MA_CP_INVALID_SLAVE_ADDRESS ((TLR_RESULT)0xC070000AL)

//
// MessageId: TLR_E_SIII_MA_CP_TELEGRAM_OFFSET_CANNOT_BE_IN_MDT_TELEGRAM
//
// MessageText:
//
//  Telegram offset cannot be set to MDT telegram.
//
#define TLR_E_SIII_MA_CP_TELEGRAM_OFFSET_CANNOT_BE_IN_MDT_TELEGRAM ((TLR_RESULT)0xC070000BL)

//
// MessageId: TLR_E_SIII_MA_CP_TELEGRAM_OFFSET_CANNOT_BE_IN_AT_TELEGRAM
//
// MessageText:
//
//  Telegram offset cannot be set to AT telegram.
//
#define TLR_E_SIII_MA_CP_TELEGRAM_OFFSET_CANNOT_BE_IN_AT_TELEGRAM ((TLR_RESULT)0xC070000CL)

//
// MessageId: TLR_E_SIII_MA_CP_TELEGRAM_OFFSET_HAS_INVALID_TELEGRAM_NO
//
// MessageText:
//
//  Telegram offset has invalid telegram number.
//
#define TLR_E_SIII_MA_CP_TELEGRAM_OFFSET_HAS_INVALID_TELEGRAM_NO ((TLR_RESULT)0xC070000DL)

//
// MessageId: TLR_E_SIII_MA_CP_TELEGRAM_OFFSET_HAS_INVALID_OFFSET
//
// MessageText:
//
//  Telegram offset has invalid offset in frame.
//
#define TLR_E_SIII_MA_CP_TELEGRAM_OFFSET_HAS_INVALID_OFFSET ((TLR_RESULT)0xC070000EL)

//
// MessageId: TLR_E_SIII_MA_CP_MDT_SVCH_TELEGRAM_OFFSET_CANNOT_BE_IN_AT_TELEGRAM
//
// MessageText:
//
//  MDT ServiceChannel Telegram offset cannot be set to AT telegram.
//
#define TLR_E_SIII_MA_CP_MDT_SVCH_TELEGRAM_OFFSET_CANNOT_BE_IN_AT_TELEGRAM ((TLR_RESULT)0xC070000FL)

//
// MessageId: TLR_E_SIII_MA_CP_MDT_SVCH_TELEGRAM_OFFSET_HAS_INVALID_TELEGRAM_NO
//
// MessageText:
//
//  MDT ServiceChannel Telegram offset has invalid telegram number.
//
#define TLR_E_SIII_MA_CP_MDT_SVCH_TELEGRAM_OFFSET_HAS_INVALID_TELEGRAM_NO ((TLR_RESULT)0xC0700010L)

//
// MessageId: TLR_E_SIII_MA_CP_MDT_SVCH_TELEGRAM_OFFSET_HAS_INVALID_OFFSET
//
// MessageText:
//
//  MDT ServiceChannel Telegram offset has invalid offset in frame.
//
#define TLR_E_SIII_MA_CP_MDT_SVCH_TELEGRAM_OFFSET_HAS_INVALID_OFFSET ((TLR_RESULT)0xC0700011L)

//
// MessageId: TLR_E_SIII_MA_CP_AT_SVCH_TELEGRAM_OFFSET_CANNOT_BE_IN_MDT_TELEGRAM
//
// MessageText:
//
//  AT ServiceChannel Telegram offset cannot be set to MDT telegram.
//
#define TLR_E_SIII_MA_CP_AT_SVCH_TELEGRAM_OFFSET_CANNOT_BE_IN_MDT_TELEGRAM ((TLR_RESULT)0xC0700012L)

//
// MessageId: TLR_E_SIII_MA_CP_AT_SVCH_TELEGRAM_OFFSET_HAS_INVALID_TELEGRAM_NO
//
// MessageText:
//
//  AT ServiceChannel Telegram offset has invalid telegram number.
//
#define TLR_E_SIII_MA_CP_AT_SVCH_TELEGRAM_OFFSET_HAS_INVALID_TELEGRAM_NO ((TLR_RESULT)0xC0700013L)

//
// MessageId: TLR_E_SIII_MA_CP_AT_SVCH_TELEGRAM_OFFSET_HAS_INVALID_OFFSET
//
// MessageText:
//
//  AT ServiceChannel Telegram offset has invalid offset in frame.
//
#define TLR_E_SIII_MA_CP_AT_SVCH_TELEGRAM_OFFSET_HAS_INVALID_OFFSET ((TLR_RESULT)0xC0700014L)

//
// MessageId: TLR_E_SIII_MA_CP_DEV_CTRL_TELEGRAM_OFFSET_CANNOT_BE_IN_AT_TELEGRAM
//
// MessageText:
//
//  DeviceControl Telegram offset cannot be set to AT telegram.
//
#define TLR_E_SIII_MA_CP_DEV_CTRL_TELEGRAM_OFFSET_CANNOT_BE_IN_AT_TELEGRAM ((TLR_RESULT)0xC0700015L)

//
// MessageId: TLR_E_SIII_MA_CP_DEV_CTRL_TELEGRAM_OFFSET_HAS_INVALID_TELEGRAM_NO
//
// MessageText:
//
//  DeviceControl Telegram offset has invalid telegram number.
//
#define TLR_E_SIII_MA_CP_DEV_CTRL_TELEGRAM_OFFSET_HAS_INVALID_TELEGRAM_NO ((TLR_RESULT)0xC0700016L)

//
// MessageId: TLR_E_SIII_MA_CP_DEV_CTRL_TELEGRAM_OFFSET_HAS_INVALID_OFFSET
//
// MessageText:
//
//  Device Control Telegram offset has invalid offset in frame.
//
#define TLR_E_SIII_MA_CP_DEV_CTRL_TELEGRAM_OFFSET_HAS_INVALID_OFFSET ((TLR_RESULT)0xC0700017L)

//
// MessageId: TLR_E_SIII_MA_CP_DEV_STATUS_TELEGRAM_OFFSET_CANNOT_BE_IN_MDT_TELEGRAM
//
// MessageText:
//
//  DeviceControl Telegram offset cannot be set to MDT telegram.
//
#define TLR_E_SIII_MA_CP_DEV_STATUS_TELEGRAM_OFFSET_CANNOT_BE_IN_MDT_TELEGRAM ((TLR_RESULT)0xC0700018L)

//
// MessageId: TLR_E_SIII_MA_CP_DEV_STATUS_TELEGRAM_OFFSET_HAS_INVALID_TELEGRAM_NO
//
// MessageText:
//
//  DeviceStatus Telegram offset has invalid telegram number.
//
#define TLR_E_SIII_MA_CP_DEV_STATUS_TELEGRAM_OFFSET_HAS_INVALID_TELEGRAM_NO ((TLR_RESULT)0xC0700019L)

//
// MessageId: TLR_E_SIII_MA_CP_DEV_STATUS_TELEGRAM_OFFSET_HAS_INVALID_OFFSET
//
// MessageText:
//
//  DeviceStatus Telegram offset has invalid offset in frame.
//
#define TLR_E_SIII_MA_CP_DEV_STATUS_TELEGRAM_OFFSET_HAS_INVALID_OFFSET ((TLR_RESULT)0xC070001AL)

//
// MessageId: TLR_E_SIII_MA_CP_SLAVE_ALREADY_IN_CONFIGURATION
//
// MessageText:
//
//  Slave already in configuration.
//
#define TLR_E_SIII_MA_CP_SLAVE_ALREADY_IN_CONFIGURATION ((TLR_RESULT)0xC070001BL)

//
// MessageId: TLR_E_SIII_MA_CP_SLAVE_NOT_IN_CONFIGURATION
//
// MessageText:
//
//  Slave is not in configuration.
//
#define TLR_E_SIII_MA_CP_SLAVE_NOT_IN_CONFIGURATION ((TLR_RESULT)0xC070001CL)

//
// MessageId: TLR_E_SIII_MA_CP_INITCMD_SEGMENT_DOES_NOT_MATCH_FIRST_PACKET
//
// MessageText:
//
//  InitCmd segment does not match the first packet.
//
#define TLR_E_SIII_MA_CP_INITCMD_SEGMENT_DOES_NOT_MATCH_FIRST_PACKET ((TLR_RESULT)0xC070001DL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_TO_BE_IMPLEMENTED
//
// MessageText:
//
//  Unimplemented function detected.
//
#define TLR_E_SIII_MA_CP_LLD_TO_BE_IMPLEMENTED ((TLR_RESULT)0xC070001EL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_UNKNOWN_ERROR
//
// MessageText:
//
//  Unknown error.
//
#define TLR_E_SIII_MA_CP_LLD_UNKNOWN_ERROR ((TLR_RESULT)0xC070001FL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_OUT_OF_MEMORY
//
// MessageText:
//
//  Out of memory.
//
#define TLR_E_SIII_MA_CP_LLD_OUT_OF_MEMORY ((TLR_RESULT)0xC0700020L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_SERVICE_CHANNEL
//
// MessageText:
//
//  Invalid Service Channel number.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_SERVICE_CHANNEL ((TLR_RESULT)0xC0700021L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE
//
// MessageText:
//
//  Invalid Slave address.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE ((TLR_RESULT)0xC0700022L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_PHASE_TRANSITION
//
// MessageText:
//
//  Invalid Phase transition.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_PHASE_TRANSITION ((TLR_RESULT)0xC0700023L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_NO_CONFIGURATION_DATA_FOR_CP3_4
//
// MessageText:
//
//  No Configuration data for CP3/CP4 available.
//
#define TLR_E_SIII_MA_CP_LLD_NO_CONFIGURATION_DATA_FOR_CP3_4 ((TLR_RESULT)0xC0700024L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_MDT0_SIZE
//
// MessageText:
//
//  Invalid MDT0 length.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_MDT0_SIZE ((TLR_RESULT)0xC0700025L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_MDT1_SIZE
//
// MessageText:
//
//  Invalid MDT1 length.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_MDT1_SIZE ((TLR_RESULT)0xC0700026L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_MDT2_SIZE
//
// MessageText:
//
//  Invalid MDT2 length.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_MDT2_SIZE ((TLR_RESULT)0xC0700027L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_MDT3_SIZE
//
// MessageText:
//
//  Invalid MDT3 length.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_MDT3_SIZE ((TLR_RESULT)0xC0700028L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_AT0_SIZE
//
// MessageText:
//
//  Invalid AT0 length.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_AT0_SIZE ((TLR_RESULT)0xC0700029L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_AT1_SIZE
//
// MessageText:
//
//  Invalid AT1 length.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_AT1_SIZE ((TLR_RESULT)0xC070002AL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_AT2_SIZE
//
// MessageText:
//
//  Invalid AT2 length.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_AT2_SIZE ((TLR_RESULT)0xC070002BL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_AT3_SIZE
//
// MessageText:
//
//  Invalid AT3 length.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_AT3_SIZE ((TLR_RESULT)0xC070002CL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_CONTROL_OFFSET_TEL_TYPE
//
// MessageText:
//
//  Device Control offset cannot be placed into AT telegram.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_CONTROL_OFFSET_TEL_TYPE ((TLR_RESULT)0xC070002DL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_CONTROL_OFFSET_TEL_NO
//
// MessageText:
//
//  Telegram Number in Device Control offset is invalid.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_CONTROL_OFFSET_TEL_NO ((TLR_RESULT)0xC070002EL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_CONTROL_OFFSET_OFS_TOO_LOW
//
// MessageText:
//
//  Frame Offset in Device Control offset is too low.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_CONTROL_OFFSET_OFS_TOO_LOW ((TLR_RESULT)0xC070002FL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_CONTROL_OFFSET_OFS_TOO_HIGH
//
// MessageText:
//
//  Frame Offset in Device Control offset is too high.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_CONTROL_OFFSET_OFS_TOO_HIGH ((TLR_RESULT)0xC0700030L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_CONTROL_OFFSET_OFS_NOT_EVEN
//
// MessageText:
//
//  Frame Offset in Device Control offset is not word-aligned (16bit word).
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_CONTROL_OFFSET_OFS_NOT_EVEN ((TLR_RESULT)0xC0700031L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_STATUS_OFFSET_TEL_TYPE
//
// MessageText:
//
//  Device Status offset cannot be placed into MDT telegram.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_STATUS_OFFSET_TEL_TYPE ((TLR_RESULT)0xC0700032L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_STATUS_OFFSET_TEL_NO
//
// MessageText:
//
//  Telegram Number in Device Status offset is invalid.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_STATUS_OFFSET_TEL_NO ((TLR_RESULT)0xC0700033L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_STATUS_OFFSET_OFS_TOO_LOW
//
// MessageText:
//
//  Frame Offset in Device Status offset is too low.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_STATUS_OFFSET_OFS_TOO_LOW ((TLR_RESULT)0xC0700034L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_STATUS_OFFSET_OFS_TOO_HIGH
//
// MessageText:
//
//  Frame Offset in Device Status offset is too high.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_STATUS_OFFSET_OFS_TOO_HIGH ((TLR_RESULT)0xC0700035L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_STATUS_OFFSET_OFS_NOT_EVEN
//
// MessageText:
//
//  Frame Offset in Device Status offset is not word-aligned (16bit word).
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_DEVICE_STATUS_OFFSET_OFS_NOT_EVEN ((TLR_RESULT)0xC0700036L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_MDT_SVC_CHANNEL_OFFSET_TEL_TYPE
//
// MessageText:
//
//  MDT Service Channel offset cannot be placed into AT telegram.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_MDT_SVC_CHANNEL_OFFSET_TEL_TYPE ((TLR_RESULT)0xC0700037L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_MDT_SVC_CHANNEL_OFFSET_TEL_NO
//
// MessageText:
//
//  Telegram Number in MDT Service Channel offset is invalid.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_MDT_SVC_CHANNEL_OFFSET_TEL_NO ((TLR_RESULT)0xC0700038L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_MDT_SVC_CHANNEL_OFFSET_OFS_TOO_LOW
//
// MessageText:
//
//  Frame Offset in MDT Service Channel offset is too low.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_MDT_SVC_CHANNEL_OFFSET_OFS_TOO_LOW ((TLR_RESULT)0xC0700039L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_MDT_SVC_CHANNEL_OFFSET_OFS_TOO_HIGH
//
// MessageText:
//
//  Frame Offset in MDT Service Channel offset is too high.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_MDT_SVC_CHANNEL_OFFSET_OFS_TOO_HIGH ((TLR_RESULT)0xC070003AL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_MDT_SVC_CHANNEL_OFFSET_OFS_NOT_EVEN
//
// MessageText:
//
//  Frame Offset in MDT Service Channel offset is not word-aligned (16bit word).
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_MDT_SVC_CHANNEL_OFFSET_OFS_NOT_EVEN ((TLR_RESULT)0xC070003BL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_AT_SVC_CHANNEL_OFFSET_TEL_TYPE
//
// MessageText:
//
//  AT Service Channel offset cannot be placed into MDT telegram.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_AT_SVC_CHANNEL_OFFSET_TEL_TYPE ((TLR_RESULT)0xC070003CL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_AT_SVC_CHANNEL_OFFSET_TEL_NO
//
// MessageText:
//
//  Telegram Number in AT Service Channel offset is invalid.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_AT_SVC_CHANNEL_OFFSET_TEL_NO ((TLR_RESULT)0xC070003DL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_AT_SVC_CHANNEL_OFFSET_OFS_TOO_LOW
//
// MessageText:
//
//  Frame Offset in AT Service Channel offset is too low.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_AT_SVC_CHANNEL_OFFSET_OFS_TOO_LOW ((TLR_RESULT)0xC070003EL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_AT_SVC_CHANNEL_OFFSET_OFS_TOO_HIGH
//
// MessageText:
//
//  Frame Offset in AT Service Channel offset is too high.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_AT_SVC_CHANNEL_OFFSET_OFS_TOO_HIGH ((TLR_RESULT)0xC070003FL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_AT_SVC_CHANNEL_OFFSET_OFS_NOT_EVEN
//
// MessageText:
//
//  Frame Offset in AT Service Channel offset is not word-aligned (16bit word).
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_AT_SVC_CHANNEL_OFFSET_OFS_NOT_EVEN ((TLR_RESULT)0xC0700040L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_MDT_RTDATA_OFFSET_TEL_TYPE
//
// MessageText:
//
//  MDT Connection offset cannot be placed into AT telegram.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_MDT_RTDATA_OFFSET_TEL_TYPE ((TLR_RESULT)0xC0700041L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_MDT_RTDATA_OFFSET_TEL_NO
//
// MessageText:
//
//  Telegram Number in MDT Connection offset is invalid.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_MDT_RTDATA_OFFSET_TEL_NO ((TLR_RESULT)0xC0700042L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_MDT_RTDATA_OFFSET_OFS_TOO_LOW
//
// MessageText:
//
//  Frame Offset in MDT Connection offset is too low.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_MDT_RTDATA_OFFSET_OFS_TOO_LOW ((TLR_RESULT)0xC0700043L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_MDT_RTDATA_OFFSET_OFS_TOO_HIGH
//
// MessageText:
//
//  Frame Offset in MDT Connection offset is too high.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_MDT_RTDATA_OFFSET_OFS_TOO_HIGH ((TLR_RESULT)0xC0700044L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_MDT_RTDATA_OFFSET_OFS_NOT_EVEN
//
// MessageText:
//
//  Frame Offset in AT Connection offset is not word-aligned (16bit word).
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_MDT_RTDATA_OFFSET_OFS_NOT_EVEN ((TLR_RESULT)0xC0700045L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_AT_RTDATA_OFFSET_TEL_TYPE
//
// MessageText:
//
//  AT Connection offset cannot be placed into MDT telegram.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_AT_RTDATA_OFFSET_TEL_TYPE ((TLR_RESULT)0xC0700046L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_AT_RTDATA_OFFSET_TEL_NO
//
// MessageText:
//
//  Telegram Number in AT Connection offset is invalid.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_AT_RTDATA_OFFSET_TEL_NO ((TLR_RESULT)0xC0700047L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_AT_RTDATA_OFFSET_OFS_TOO_LOW
//
// MessageText:
//
//  Frame Offset in AT Connection offset is too low.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_AT_RTDATA_OFFSET_OFS_TOO_LOW ((TLR_RESULT)0xC0700048L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_AT_RTDATA_OFFSET_OFS_TOO_HIGH
//
// MessageText:
//
//  Frame Offset in AT Connection offset is too high.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_AT_RTDATA_OFFSET_OFS_TOO_HIGH ((TLR_RESULT)0xC0700049L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_AT_RTDATA_OFFSET_OFS_NOT_EVEN
//
// MessageText:
//
//  Frame Offset in MDT Connection offset is not word-aligned (16bit word).
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_AT_RTDATA_OFFSET_OFS_NOT_EVEN ((TLR_RESULT)0xC070004AL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_OVERLAPPING_REGIONS_DETECTED_IN_MDT_FRAMES
//
// MessageText:
//
//  Overlapping regions detected within MDT frames.
//
#define TLR_E_SIII_MA_CP_LLD_OVERLAPPING_REGIONS_DETECTED_IN_MDT_FRAMES ((TLR_RESULT)0xC070004BL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_OVERLAPPING_REGIONS_DETECTED_IN_AT_FRAMES
//
// MessageText:
//
//  Overlapping regions detected within AT frames.
//
#define TLR_E_SIII_MA_CP_LLD_OVERLAPPING_REGIONS_DETECTED_IN_AT_FRAMES ((TLR_RESULT)0xC070004CL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_SLAVE_ADDRESS_IN_CP3_4_CONFIG
//
// MessageText:
//
//  Invalid Slave address in CP3/CP4 configuration data.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_SLAVE_ADDRESS_IN_CP3_4_CONFIG ((TLR_RESULT)0xC070004DL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_CONFIGURE_NOT_ALLOWED_IN_CURRENT_STATE
//
// MessageText:
//
//  Configuring CP3/CP4 not allowed in current state.
//
#define TLR_E_SIII_MA_CP_LLD_CONFIGURE_NOT_ALLOWED_IN_CURRENT_STATE ((TLR_RESULT)0xC070004EL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_BUILDING_COPY_ROUTINES_FAILED
//
// MessageText:
//
//  Building of copy routines failed.
//
#define TLR_E_SIII_MA_CP_LLD_BUILDING_COPY_ROUTINES_FAILED ((TLR_RESULT)0xC070004FL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_MDT_CONNCTRL_PROCESS_IMAGE_OFFSET
//
// MessageText:
//
//  Invalid MDT Connection Control Process Image offset.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_MDT_CONNCTRL_PROCESS_IMAGE_OFFSET ((TLR_RESULT)0xC0700050L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_MDT_RTDATA_PROCESS_IMAGE_OFFSET
//
// MessageText:
//
//  Invalid MDT real time data Process Image offset.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_MDT_RTDATA_PROCESS_IMAGE_OFFSET ((TLR_RESULT)0xC0700051L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_AT_CONNCTRL_PROCESS_IMAGE_OFFSET
//
// MessageText:
//
//  Invalid AT Connection Control Process Image offset.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_AT_CONNCTRL_PROCESS_IMAGE_OFFSET ((TLR_RESULT)0xC0700052L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_AT_RTDATA_PROCESS_IMAGE_OFFSET
//
// MessageText:
//
//  Invalid AT real time data Control Process Image offset.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_AT_RTDATA_PROCESS_IMAGE_OFFSET ((TLR_RESULT)0xC0700053L)

//
// MessageId: TLR_E_SIII_MA_CP_CONFIGURATION_NOT_POSSIBLE_IN_CURRENT_STATE
//
// MessageText:
//
//  Configuration not possible in current master state.
//
#define TLR_E_SIII_MA_CP_CONFIGURATION_NOT_POSSIBLE_IN_CURRENT_STATE ((TLR_RESULT)0xC0700054L)

//
// MessageId: TLR_E_SIII_MA_CP_PHASE_CHANGE_IN_PROGRESS
//
// MessageText:
//
//  Phase Change is in progress.
//
#define TLR_E_SIII_MA_CP_PHASE_CHANGE_IN_PROGRESS ((TLR_RESULT)0xC0700055L)

//
// MessageId: TLR_E_SIII_MA_CP_REQUESTED_PHASE_IS_ALREADY_CURRENT_PHASE
//
// MessageText:
//
//  Requested Phase is already current phase.
//
#define TLR_E_SIII_MA_CP_REQUESTED_PHASE_IS_ALREADY_CURRENT_PHASE ((TLR_RESULT)0xC0700056L)

//
// MessageId: TLR_E_SIII_MA_CP_FINISH_CONFIGURATION_DOWNLOAD_FIRST
//
// MessageText:
//
//  Finish configuration download first.
//
#define TLR_E_SIII_MA_CP_FINISH_CONFIGURATION_DOWNLOAD_FIRST ((TLR_RESULT)0xC0700057L)

//
// MessageId: TLR_E_SIII_MA_CP_NO_CONFIGURATION_FOR_CP3_AVAILABLE
//
// MessageText:
//
//  No configuration for CP3 available.
//
#define TLR_E_SIII_MA_CP_NO_CONFIGURATION_FOR_CP3_AVAILABLE ((TLR_RESULT)0xC0700058L)

//
// MessageId: TLR_E_SIII_MA_CP_NO_CONFIGURATION_FOR_CP4_AVAILABLE
//
// MessageText:
//
//  No configuration for CP4 available.
//
#define TLR_E_SIII_MA_CP_NO_CONFIGURATION_FOR_CP4_AVAILABLE ((TLR_RESULT)0xC0700059L)

//
// MessageId: TLR_E_SIII_MA_CP_INCOMPLETE_INITCMD_DOWNLOAD
//
// MessageText:
//
//  Incomplete InitCmd download detected.
//
#define TLR_E_SIII_MA_CP_INCOMPLETE_INITCMD_DOWNLOAD ((TLR_RESULT)0xC070005AL)

//
// MessageId: TLR_E_SIII_MA_CP_INVALID_TRANSITION_FLAGS
//
// MessageText:
//
//  Invalid transition flags specified in InitCmd download.
//
#define TLR_E_SIII_MA_CP_INVALID_TRANSITION_FLAGS ((TLR_RESULT)0xC070005BL)

//
// MessageId: TLR_E_SIII_MA_CP_INVALID_INITCMD_LENGTH
//
// MessageText:
//
//  Invalid length specified in InitCmd download.
//
#define TLR_E_SIII_MA_CP_INVALID_INITCMD_LENGTH ((TLR_RESULT)0xC070005CL)

//
// MessageId: TLR_E_SIII_MA_CP_PHASE_INDS_RECEIVER_LIST_IS_FULL
//
// MessageText:
//
//  Phase Indication receiver list is full.
//
#define TLR_E_SIII_MA_CP_PHASE_INDS_RECEIVER_LIST_IS_FULL ((TLR_RESULT)0xC070005DL)

//
// MessageId: TLR_E_SIII_MA_CP_APP_NOT_REGISTERED
//
// MessageText:
//
//  Application queue is not registered.
//
#define TLR_E_SIII_MA_CP_APP_NOT_REGISTERED ((TLR_RESULT)0xC070005EL)

//
// MessageId: TLR_E_SIII_MA_CP_APP_REGISTERED_ALREADY
//
// MessageText:
//
//  Application queue is registered already.
//
#define TLR_E_SIII_MA_CP_APP_REGISTERED_ALREADY ((TLR_RESULT)0xC070005FL)

//
// MessageId: TLR_I_SIII_MA_CP_BUS_IS_OFF
//
// MessageText:
//
//  Please issue the BusOn command, since the bus is off.
//
#define TLR_I_SIII_MA_CP_BUS_IS_OFF      ((TLR_RESULT)0x40700060L)

//
// MessageId: TLR_E_SIII_MA_CP_NO_DIAG_ENTRY_AVAILABLE
//
// MessageText:
//
//  No further diagnostic entries currently available.
//
#define TLR_E_SIII_MA_CP_NO_DIAG_ENTRY_AVAILABLE ((TLR_RESULT)0xC0700061L)

//
// MessageId: TLR_E_SIII_MA_CP_LOCKED_DUE_TO_ERROR_IN_PREVIOUS_PHASE_SWITCH
//
// MessageText:
//
//  Locked due to error in previous phase switch.
//
#define TLR_E_SIII_MA_CP_LOCKED_DUE_TO_ERROR_IN_PREVIOUS_PHASE_SWITCH ((TLR_RESULT)0xC0700062L)

//
// MessageId: TLR_E_SIII_MA_CP_LOCKED_DUE_TO_DPM_WATCHDOG_ERROR
//
// MessageText:
//
//  Locked due to error on DPM watchdog.
//
#define TLR_E_SIII_MA_CP_LOCKED_DUE_TO_DPM_WATCHDOG_ERROR ((TLR_RESULT)0xC0700063L)

//
// MessageId: TLR_E_SIII_MA_CP_BUS_SCAN_NOT_POSSIBLE_WITHOUT_BUS_ON
//
// MessageText:
//
//  Bus Scan not possible without Bus On.
//
#define TLR_E_SIII_MA_CP_BUS_SCAN_NOT_POSSIBLE_WITHOUT_BUS_ON ((TLR_RESULT)0xC0700064L)

//
// MessageId: TLR_E_SIII_MA_CP_ELECTRONIC_LABEL_NOT_READABLE
//
// MessageText:
//
//  Electronic Label could not be read.
//
#define TLR_E_SIII_MA_CP_ELECTRONIC_LABEL_NOT_READABLE ((TLR_RESULT)0xC0700065L)

//
// MessageId: TLR_E_SIII_MA_CP_BUS_SCAN_ALREADY_ACTIVE
//
// MessageText:
//
//  Bus Scan already active.
//
#define TLR_E_SIII_MA_CP_BUS_SCAN_ALREADY_ACTIVE ((TLR_RESULT)0xC0700066L)

//
// MessageId: TLR_E_SIII_MA_CP_BUS_SCAN_ABORTED
//
// MessageText:
//
//  Bus Scan aborted.
//
#define TLR_E_SIII_MA_CP_BUS_SCAN_ABORTED ((TLR_RESULT)0xC0700067L)

//
// MessageId: TLR_E_SIII_MA_CP_TIMING_PARAMETER_NRT_CHANNEL_EXCEEDS_CYCLE_TIME
//
// MessageText:
//
//  NRT Channel exceeds cycle time.
//
#define TLR_E_SIII_MA_CP_TIMING_PARAMETER_NRT_CHANNEL_EXCEEDS_CYCLE_TIME ((TLR_RESULT)0xC0700068L)

//
// MessageId: TLR_E_SIII_MA_CP_TIMING_PARAMETER_END_OF_MDT_IS_LATER_THAN_START_OF_AT
//
// MessageText:
//
//  End of MDT is later than start of AT.
//
#define TLR_E_SIII_MA_CP_TIMING_PARAMETER_END_OF_MDT_IS_LATER_THAN_START_OF_AT ((TLR_RESULT)0xC0700069L)

//
// MessageId: TLR_E_SIII_MA_CP_TIMING_PARAMETER_END_OF_MDT_EXCEEDS_CYCLE_TIME
//
// MessageText:
//
//  End of MDT exceeds cycle time.
//
#define TLR_E_SIII_MA_CP_TIMING_PARAMETER_END_OF_MDT_EXCEEDS_CYCLE_TIME ((TLR_RESULT)0xC070006AL)

//
// MessageId: TLR_E_SIII_MA_CP_TIMING_PARAMETER_START_OF_AT_EXCEEDS_CYCLE_TIME
//
// MessageText:
//
//  Start of AT exceeds cycle time.
//
#define TLR_E_SIII_MA_CP_TIMING_PARAMETER_START_OF_AT_EXCEEDS_CYCLE_TIME ((TLR_RESULT)0xC070006BL)

//
// MessageId: TLR_E_SIII_MA_CP_TIMING_PARAMETER_END_OF_AT_EXCEEDS_CYCLE_TIME
//
// MessageText:
//
//  End of AT exceeds cycle time.
//
#define TLR_E_SIII_MA_CP_TIMING_PARAMETER_END_OF_AT_EXCEEDS_CYCLE_TIME ((TLR_RESULT)0xC070006CL)

//
// MessageId: TLR_E_SIII_MA_CP_TIMING_PARAMETER_END_OF_NRT_IS_EARLIER_THAN_START_OF_NRT
//
// MessageText:
//
//  End of NRT is earlier than start of NRT.
//
#define TLR_E_SIII_MA_CP_TIMING_PARAMETER_END_OF_NRT_IS_EARLIER_THAN_START_OF_NRT ((TLR_RESULT)0xC070006DL)

//
// MessageId: TLR_E_SIII_MA_CP_TIMING_PARAMETER_NRT_CHANNEL_OVERLAPS_MDT_TRANSMISSION
//
// MessageText:
//
//  NRT Channel overlaps MDT transmission.
//
#define TLR_E_SIII_MA_CP_TIMING_PARAMETER_NRT_CHANNEL_OVERLAPS_MDT_TRANSMISSION ((TLR_RESULT)0xC070006EL)

//
// MessageId: TLR_E_SIII_MA_CP_TIMING_PARAMETER_NRT_CHANNEL_OVERLAPS_AT_TRANSMISSION
//
// MessageText:
//
//  NRT Channel overlaps AT transmission.
//
#define TLR_E_SIII_MA_CP_TIMING_PARAMETER_NRT_CHANNEL_OVERLAPS_AT_TRANSMISSION ((TLR_RESULT)0xC070006FL)

//
// MessageId: TLR_E_SIII_MA_CP_TIMING_PARAMETER_START_OF_AT_IS_EARLIER_THAN_START_OF_MDT
//
// MessageText:
//
//  Start of AT is earlier than start of MDT.
//
#define TLR_E_SIII_MA_CP_TIMING_PARAMETER_START_OF_AT_IS_EARLIER_THAN_START_OF_MDT ((TLR_RESULT)0xC0700070L)

//
// MessageId: TLR_E_SIII_MA_CP_LOCKED_DUE_PREVIOUS_FATAL_ERROR
//
// MessageText:
//
//  Locked due previous fatal error.
//
#define TLR_E_SIII_MA_CP_LOCKED_DUE_PREVIOUS_FATAL_ERROR ((TLR_RESULT)0xC0700071L)

//
// MessageId: TLR_E_SIII_MA_CP_TOPOLOGY_INFO_NOT_VALID_AT_THE_MOMENT
//
// MessageText:
//
//  Topology info not valid at the moment.
//
#define TLR_E_SIII_MA_CP_TOPOLOGY_INFO_NOT_VALID_AT_THE_MOMENT ((TLR_RESULT)0xC0700072L)

//
// MessageId: TLR_E_SIII_MA_CP_AT_TRANSMISSION_START_TIME_EXCEEDS_CYCLE_TIME
//
// MessageText:
//
//  AT Transmission start time exceeds cycle time.
//
#define TLR_E_SIII_MA_CP_AT_TRANSMISSION_START_TIME_EXCEEDS_CYCLE_TIME ((TLR_RESULT)0xC0700073L)

//
// MessageId: TLR_E_SIII_MA_CP_NRT_START_TIME_EXCEEDS_CYCLE_TIME
//
// MessageText:
//
//  NRT start time exceeds cycle time.
//
#define TLR_E_SIII_MA_CP_NRT_START_TIME_EXCEEDS_CYCLE_TIME ((TLR_RESULT)0xC0700074L)

//
// MessageId: TLR_E_SIII_MA_CP_NRT_END_TIME_EXCEEDS_CYCLE_TIME
//
// MessageText:
//
//  NRT End time exceeds cycle time.
//
#define TLR_E_SIII_MA_CP_NRT_END_TIME_EXCEEDS_CYCLE_TIME ((TLR_RESULT)0xC0700075L)

//
// MessageId: TLR_E_SIII_MA_CP_NRT_START_TIME_IS_GREATER_THAN_NRT_END_TIME
//
// MessageText:
//
//  NRT End time is greater than NRT start time.
//
#define TLR_E_SIII_MA_CP_NRT_START_TIME_IS_GREATER_THAN_NRT_END_TIME ((TLR_RESULT)0xC0700076L)

//
// MessageId: TLR_E_SIII_MA_CP_TOPOLOGY_REQUEST_ABORTED_DUE_NRT
//
// MessageText:
//
//  Topology Request aborted due NRT phase.
//
#define TLR_E_SIII_MA_CP_TOPOLOGY_REQUEST_ABORTED_DUE_NRT ((TLR_RESULT)0xC0700077L)

//
// MessageId: TLR_E_SIII_MA_CP_TOPOLOGY_REQUEST_ABORTED_DUE_CP0
//
// MessageText:
//
//  Topology Request aborted due CP0 phase.
//
#define TLR_E_SIII_MA_CP_TOPOLOGY_REQUEST_ABORTED_DUE_CP0 ((TLR_RESULT)0xC0700078L)

//
// MessageId: TLR_E_SIII_MA_CP_TOPOLOGY_REQUEST_ABORTED_DUE_TIMEOUT
//
// MessageText:
//
//  Topology Request aborted due timeout.
//
#define TLR_E_SIII_MA_CP_TOPOLOGY_REQUEST_ABORTED_DUE_TIMEOUT ((TLR_RESULT)0xC0700079L)

//
// MessageId: TLR_E_SIII_MA_CP_TOPOLOGY_REQUEST_ABORTED_DUE_UNRELATED_SLAVE_TOPOLOGY_CHANGE
//
// MessageText:
//
//  Topology Request aborted other unrelated slave changed topology state.
//
#define TLR_E_SIII_MA_CP_TOPOLOGY_REQUEST_ABORTED_DUE_UNRELATED_SLAVE_TOPOLOGY_CHANGE ((TLR_RESULT)0xC070007AL)

//
// MessageId: TLR_E_SIII_MA_CP_TOPOLOGY_REQUEST_ABORTED_DUE_SLAVE_DENIED_TOPOLOGY_CHANGE
//
// MessageText:
//
//  Topology Request aborted due to slave denying topology state change.
//
#define TLR_E_SIII_MA_CP_TOPOLOGY_REQUEST_ABORTED_DUE_SLAVE_DENIED_TOPOLOGY_CHANGE ((TLR_RESULT)0xC070007BL)

//
// MessageId: TLR_E_SIII_MA_CP_TOPOLOGY_NOT_ALLOWED_CURRENTLY
//
// MessageText:
//
//  Topology Request not allowed currently due to topology status.
//
#define TLR_E_SIII_MA_CP_TOPOLOGY_NOT_ALLOWED_CURRENTLY ((TLR_RESULT)0xC070007CL)

//
// MessageId: TLR_E_SIII_MA_CP_SLAVE_NOT_IN_TOPOLOGY
//
// MessageText:
//
//  Slave not in topology.
//
#define TLR_E_SIII_MA_CP_SLAVE_NOT_IN_TOPOLOGY ((TLR_RESULT)0xC070007DL)

//
// MessageId: TLR_E_SIII_MA_CP_ANOTHER_TOPOLOGY_REQUEST_IN_PROGRESS
//
// MessageText:
//
//  Another Topology Request in progress.
//
#define TLR_E_SIII_MA_CP_ANOTHER_TOPOLOGY_REQUEST_IN_PROGRESS ((TLR_RESULT)0xC070007EL)

//
// MessageId: TLR_E_SIII_MA_CP_SLAVE_CONFIGURATION_FLAGS_INVALID
//
// MessageText:
//
//  Invalid slave configuration flags.
//
#define TLR_E_SIII_MA_CP_SLAVE_CONFIGURATION_FLAGS_INVALID ((TLR_RESULT)0xC070007FL)

//
// MessageId: TLR_E_SIII_MA_CP_SLAVE_INVALID_ELEMENT_ID_IN_ADD_INITCMD
//
// MessageText:
//
//  Invalid element id in Add InitCmd.
//
#define TLR_E_SIII_MA_CP_SLAVE_INVALID_ELEMENT_ID_IN_ADD_INITCMD ((TLR_RESULT)0xC0700080L)

//
// MessageId: TLR_E_SIII_MA_CP_SLAVE_INVALID_ACTION_IN_ADD_INITCMD
//
// MessageText:
//
//  Invalid action in Add InitCmd.
//
#define TLR_E_SIII_MA_CP_SLAVE_INVALID_ACTION_IN_ADD_INITCMD ((TLR_RESULT)0xC0700081L)

//
// MessageId: TLR_E_SIII_MA_CP_BUS_SCAN_NOT_ACTIVE
//
// MessageText:
//
//  Bus Scan not active.
//
#define TLR_E_SIII_MA_CP_BUS_SCAN_NOT_ACTIVE ((TLR_RESULT)0xC0700082L)

//
// MessageId: TLR_E_SIII_MA_CP_SLAVE_NOT_IN_BUS_COMMUNICATION
//
// MessageText:
//
//  Slave not in bus communication.
//
#define TLR_E_SIII_MA_CP_SLAVE_NOT_IN_BUS_COMMUNICATION ((TLR_RESULT)0xC0700083L)

//
// MessageId: TLR_E_SIII_MA_CP_HOTPLUG_SLAVE_NOT_IN_BUS_COMMUNICATION
//
// MessageText:
//
//  Hotplug Slave not in bus communication.
//
#define TLR_E_SIII_MA_CP_HOTPLUG_SLAVE_NOT_IN_BUS_COMMUNICATION ((TLR_RESULT)0xC0700084L)

//
// MessageId: TLR_E_SIII_MA_CP_C1D_DIAGNOSTIC_ERROR
//
// MessageText:
//
//  C1D-Diagnostic Error.
//
#define TLR_E_SIII_MA_CP_C1D_DIAGNOSTIC_ERROR ((TLR_RESULT)0xC0700085L)

//
// MessageId: TLR_E_SIII_MA_CP_SVC_MHS_AHS_TIMEOUT
//
// MessageText:
//
//  SVC: MHS-AHS Timeout.
//
#define TLR_E_SIII_MA_CP_SVC_MHS_AHS_TIMEOUT ((TLR_RESULT)0xC0700086L)

//
// MessageId: TLR_E_SIII_MA_CP_SVC_BUSY_TIMEOUT
//
// MessageText:
//
//  SVC: Busy Timeout.
//
#define TLR_E_SIII_MA_CP_SVC_BUSY_TIMEOUT ((TLR_RESULT)0xC0700087L)

//
// MessageId: TLR_E_SIII_MA_CP_S_0_99_COMMAND_ERROR
//
// MessageText:
//
//  S-0-99 Command execution ended with error.
//
#define TLR_E_SIII_MA_CP_S_0_99_COMMAND_ERROR ((TLR_RESULT)0xC0700088L)

//
// MessageId: TLR_E_SIII_MA_CP_MDT_NRT_AT_CONFIGURATION_NOT_SUPPORTED
//
// MessageText:
//
//  MDT/NRT/AT order not supported.
//
#define TLR_E_SIII_MA_CP_MDT_NRT_AT_CONFIGURATION_NOT_SUPPORTED ((TLR_RESULT)0xC0700089L)

//
// MessageId: TLR_E_SIII_MA_CP_INITCMD_SVCH_ERROR
//
// MessageText:
//
//  InitCmd FSM did not succeed processing configured IDN parameters due to Service channel error.
//
#define TLR_E_SIII_MA_CP_INITCMD_SVCH_ERROR ((TLR_RESULT)0xC070008AL)

//
// MessageId: TLR_E_SIII_MA_CP_INITCMD_COMPARE_FAILED
//
// MessageText:
//
//  InitCmd FSM did not succeed processing configured IDN parameters due mismatch during compare.
//
#define TLR_E_SIII_MA_CP_INITCMD_COMPARE_FAILED ((TLR_RESULT)0xC070008BL)

//
// MessageId: TLR_E_SIII_MA_CP_INITCMD_PROCCMD_FAILED
//
// MessageText:
//
//  InitCmd FSM did not succeed processing a configured procedure.
//
#define TLR_E_SIII_MA_CP_INITCMD_PROCCMD_FAILED ((TLR_RESULT)0xC070008CL)

//
// MessageId: TLR_E_SIII_MA_CP_INITCMD_SVCH_TASK_ERROR
//
// MessageText:
//
//  InitCmd FSM did not succeed due to Service Channel Task error.
//
#define TLR_E_SIII_MA_CP_INITCMD_SVCH_TASK_ERROR ((TLR_RESULT)0xC070008DL)

//
// MessageId: TLR_E_SIII_MA_CP_NOT_AVAILABLE_IN_CONFIGURATION
//
// MessageText:
//
//  Not available in configuration.
//
#define TLR_E_SIII_MA_CP_NOT_AVAILABLE_IN_CONFIGURATION ((TLR_RESULT)0xC070008EL)

//
// MessageId: TLR_E_SIII_MA_CP_NOT_ALLOWED_WITH_AUTOCFG
//
// MessageText:
//
//  Not allowed with AutoCfg active.
//
#define TLR_E_SIII_MA_CP_NOT_ALLOWED_WITH_AUTOCFG ((TLR_RESULT)0xC070008FL)

//
// MessageId: TLR_E_SIII_MA_CP_NOT_ALLOWED_WITHOUT_AUTOCFG
//
// MessageText:
//
//  Not allowed without AutoCfg active.
//
#define TLR_E_SIII_MA_CP_NOT_ALLOWED_WITHOUT_AUTOCFG ((TLR_RESULT)0xC0700090L)

//
// MessageId: TLR_E_SIII_MA_CP_MDT_SPACE_EXCEEDED
//
// MessageText:
//
//  Space of MDT frames exceeded.
//
#define TLR_E_SIII_MA_CP_MDT_SPACE_EXCEEDED ((TLR_RESULT)0xC0700091L)

//
// MessageId: TLR_E_SIII_MA_CP_AT_SPACE_EXCEEDED
//
// MessageText:
//
//  Space of AT frames exceeded.
//
#define TLR_E_SIII_MA_CP_AT_SPACE_EXCEEDED ((TLR_RESULT)0xC0700092L)

//
// MessageId: TLR_E_SIII_MA_CP_NOT_ENOUGH_SPACE_FOR_MDT_AT_TELEGRAMS
//
// MessageText:
//
//  Not enough space for MDT and AT telegrams in cycle.
//
#define TLR_E_SIII_MA_CP_NOT_ENOUGH_SPACE_FOR_MDT_AT_TELEGRAMS ((TLR_RESULT)0xC0700094L)

//
// MessageId: TLR_E_SIII_MA_CP_NOT_ENOUGH_SPACE_FOR_NRT_IN_CYCLE
//
// MessageText:
//
//  Not enough space for NRT channel in cycle.
//
#define TLR_E_SIII_MA_CP_NOT_ENOUGH_SPACE_FOR_NRT_IN_CYCLE ((TLR_RESULT)0xC0700095L)

//
// MessageId: TLR_E_SIII_MA_CP_NOT_ALLOWED_FUNCTION_TYPE_SPECIFIED
//
// MessageText:
//
//  Not allowed connection function type specified.
//
#define TLR_E_SIII_MA_CP_NOT_ALLOWED_FUNCTION_TYPE_SPECIFIED ((TLR_RESULT)0xC0700096L)

//
// MessageId: TLR_E_SIII_MA_CP_UNKNOWN_FUNCTION_TYPE_SPECIFIED
//
// MessageText:
//
//  Unknown connection function type specified.
//
#define TLR_E_SIII_MA_CP_UNKNOWN_FUNCTION_TYPE_SPECIFIED ((TLR_RESULT)0xC0700097L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_BUFFER_OUT_OF_SYNC
//
// MessageText:
//
//  LLD: Buffer Out of Sync.
//
#define TLR_E_SIII_MA_CP_LLD_BUFFER_OUT_OF_SYNC ((TLR_RESULT)0xC0700099L)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_INVALID_PARAMETER
//
// MessageText:
//
//  LLD: Invalid Parameter.
//
#define TLR_E_SIII_MA_CP_LLD_INVALID_PARAMETER ((TLR_RESULT)0xC070009AL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_EXCEPTION_OCCURED
//
// MessageText:
//
//  LLD: Exception occured.
//
#define TLR_E_SIII_MA_CP_LLD_EXCEPTION_OCCURED ((TLR_RESULT)0xC070009CL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_CONNECTION_LOST
//
// MessageText:
//
//  LLD: Connection lost.
//
#define TLR_E_SIII_MA_CP_LLD_CONNECTION_LOST ((TLR_RESULT)0xC070009DL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_REQUEST_TIMEOUT
//
// MessageText:
//
//  LLD: Request Timeout.
//
#define TLR_E_SIII_MA_CP_LLD_REQUEST_TIMEOUT ((TLR_RESULT)0xC070009EL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_ACCESS_ERROR
//
// MessageText:
//
//  LLD: Access Error.
//
#define TLR_E_SIII_MA_CP_LLD_ACCESS_ERROR ((TLR_RESULT)0xC070009FL)

//
// MessageId: TLR_E_SIII_MA_CP_LLD_MAILBOX_ERROR
//
// MessageText:
//
//  LLD: Mailbox Error.
//
#define TLR_E_SIII_MA_CP_LLD_MAILBOX_ERROR ((TLR_RESULT)0xC07000A0L)

//
// MessageId: TLR_E_SIII_MA_CP_SLAVE_IDENT_ALREADY_ADDED
//
// MessageText:
//
//  Slave Identification data already added.
//
#define TLR_E_SIII_MA_CP_SLAVE_IDENT_ALREADY_ADDED ((TLR_RESULT)0xC07000A1L)

//
// MessageId: TLR_E_SIII_MA_CP_SLAVE_IDENT_DATA_NOT_AVAILABLE
//
// MessageText:
//
//  Slave Identification data not available.
//
#define TLR_E_SIII_MA_CP_SLAVE_IDENT_DATA_NOT_AVAILABLE ((TLR_RESULT)0xC07000A2L)

//
// MessageId: TLR_E_SIII_MA_CP_CONNECTION_NOT_IN_CONFIGURATION
//
// MessageText:
//
//  Connection Instance is not in configuration.
//
#define TLR_E_SIII_MA_CP_CONNECTION_NOT_IN_CONFIGURATION ((TLR_RESULT)0xC07000A3L)

//
// MessageId: TLR_E_SIII_MA_CP_CONNECTION_LAYOUT_NOT_IN_CONFIGURATION
//
// MessageText:
//
//  Connection Instance layout is not in configuration.
//
#define TLR_E_SIII_MA_CP_CONNECTION_LAYOUT_NOT_IN_CONFIGURATION ((TLR_RESULT)0xC07000A4L)

//
// MessageId: TLR_E_SIII_MA_CP_CONNECTION_LAYOUT_ALREADY_IN_CONFIGURATION
//
// MessageText:
//
//  Connection Instance layout is already in configuration.
//
#define TLR_E_SIII_MA_CP_CONNECTION_LAYOUT_ALREADY_IN_CONFIGURATION ((TLR_RESULT)0xC07000A5L)

//
// MessageId: TLR_E_SIII_MA_CP_NRT_WINDOW_AND_NRT_MTU_CANNOT_BE_SATISFIED
//
// MessageText:
//
//  NRT Window and NRT MTU cannot be satisfied.
//
#define TLR_E_SIII_MA_CP_NRT_WINDOW_AND_NRT_MTU_CANNOT_BE_SATISFIED ((TLR_RESULT)0xC07000A6L)

//
// MessageId: TLR_E_SIII_MA_CP_DEPRECATED_NRT_OFF_CONFIGURATION
//
// MessageText:
//
//  Deprecated NRT off configuration used (t6 == t7). Please set t6 to 0.
//
#define TLR_E_SIII_MA_CP_DEPRECATED_NRT_OFF_CONFIGURATION ((TLR_RESULT)0xC07000A7L)

//
// MessageId: TLR_E_SIII_MA_CP_INVALID_CYCLE_TIME
//
// MessageText:
//
//  Invalid cycle time used (not sercos-defined).
//
#define TLR_E_SIII_MA_CP_INVALID_CYCLE_TIME ((TLR_RESULT)0xC07000A8L)

//
// MessageId: TLR_E_SIII_MA_CP_INVALID_MAX_TSREF_COUNTER
//
// MessageText:
//
//  Invalid value for maximum TS-ref counter.
//
#define TLR_E_SIII_MA_CP_INVALID_MAX_TSREF_COUNTER ((TLR_RESULT)0xC07000A9L)

//
// MessageId: TLR_E_SIII_MA_CP_DEVICE_IDENT_MISMATCH
//
// MessageText:
//
//  Device Ident Mismatch.
//
#define TLR_E_SIII_MA_CP_DEVICE_IDENT_MISMATCH ((TLR_RESULT)0xC07000AAL)

//
// MessageId: TLR_E_SIII_MA_CP_CP1_CP2_NRT_WINDOW_INVALID
//
// MessageText:
//
//  CP1/CP2 NRT Window parameters invalid.
//
#define TLR_E_SIII_MA_CP_CP1_CP2_NRT_WINDOW_INVALID ((TLR_RESULT)0xC07000ABL)

//
// MessageId: TLR_E_SIII_MA_CP_CP1_CP2_AT_START_TIME_INVALID
//
// MessageText:
//
//  CP1/CP2 AT Start Time invalid.
//
#define TLR_E_SIII_MA_CP_CP1_CP2_AT_START_TIME_INVALID ((TLR_RESULT)0xC07000ACL)

//
// MessageId: TLR_E_SIII_MA_CP_FEATURES_NOT_ACKNOWLEDGED
//
// MessageText:
//
//  Advertised featured in CP0 are not acknowledged.
//
#define TLR_E_SIII_MA_CP_FEATURES_NOT_ACKNOWLEDGED ((TLR_RESULT)0xC07000ADL)

//
// MessageId: TLR_E_SIII_MA_CP_NOT_ALLOWED_IN_CURRENT_PHASE
//
// MessageText:
//
//  Request not allowed in current phase.
//
#define TLR_E_SIII_MA_CP_NOT_ALLOWED_IN_CURRENT_PHASE ((TLR_RESULT)0xC07000AEL)

//
// MessageId: TLR_E_SIII_MA_CP_MANDATORY_SLAVE_LIST_VARIANT_ALREADY_ADDED
//
// MessageText:
//
//  Mandatory slave list variant already added.
//
#define TLR_E_SIII_MA_CP_MANDATORY_SLAVE_LIST_VARIANT_ALREADY_ADDED ((TLR_RESULT)0xC07000AFL)

//
// MessageId: TLR_E_SIII_MA_CP_SCP_CLASS_HANDLED_INTERNALLY
//
// MessageText:
//
//  SCP Class is handled internally by master.
//
#define TLR_E_SIII_MA_CP_SCP_CLASS_HANDLED_INTERNALLY ((TLR_RESULT)0xC07000B0L)

//
// MessageId: TLR_E_SIII_MA_CP_OVERLAPPING_INPUT_DATA_IN_PROCESS_IMAGE
//
// MessageText:
//
//  Overlapping input data offsets in process image.
//
#define TLR_E_SIII_MA_CP_OVERLAPPING_INPUT_DATA_IN_PROCESS_IMAGE ((TLR_RESULT)0xC07000B1L)

//
// MessageId: TLR_E_SIII_MA_CP_SCP_NRT_CONFIGURATION_ALREADY_ADDED
//
// MessageText:
//
//  SCP_NRT/SCP_NRTPC configuration already added.
//
#define TLR_E_SIII_MA_CP_SCP_NRT_CONFIGURATION_ALREADY_ADDED ((TLR_RESULT)0xC07000B2L)

//
// MessageId: TLR_E_SIII_MA_CP_DUPLICATE_SLAVE_ADDRESS
//
// MessageText:
//
//  Duplicate slaveaddress specified.
//
#define TLR_E_SIII_MA_CP_DUPLICATE_SLAVE_ADDRESS ((TLR_RESULT)0xC07000B3L)

//
// MessageId: TLR_E_SIII_MA_CP_IP_NETWORK_ADDRESSES_NOT_IDENTICAL
//
// MessageText:
//
//  IP: Network addresses are not identical.
//
#define TLR_E_SIII_MA_CP_IP_NETWORK_ADDRESSES_NOT_IDENTICAL ((TLR_RESULT)0xC07000B4L)

//
// MessageId: TLR_E_SIII_MA_CP_IP_INVALID_IP_ADDRESS
//
// MessageText:
//
//  IP: Invalid IP address.
//
#define TLR_E_SIII_MA_CP_IP_INVALID_IP_ADDRESS ((TLR_RESULT)0xC07000B5L)

//
// MessageId: TLR_E_SIII_MA_CP_IP_SUBNET_MASKS_NOT_IDENTICAL
//
// MessageText:
//
//  IP: Subnet masks are not identical.
//
#define TLR_E_SIII_MA_CP_IP_SUBNET_MASKS_NOT_IDENTICAL ((TLR_RESULT)0xC07000B6L)

//
// MessageId: TLR_E_SIII_MA_CP_IP_INVALID_GATEWAY_ADDRESS
//
// MessageText:
//
//  IP: Invalid gateway address.
//
#define TLR_E_SIII_MA_CP_IP_INVALID_GATEWAY_ADDRESS ((TLR_RESULT)0xC07000B7L)

//
// MessageId: TLR_E_SIII_MA_CP_NOT_POSSIBLE_DUE_CONFIGURATION_BUFFER_IS_OPEN
//
// MessageText:
//
//  Not possible. Configuration buffer is open.
//
#define TLR_E_SIII_MA_CP_NOT_POSSIBLE_DUE_CONFIGURATION_BUFFER_IS_OPEN ((TLR_RESULT)0xC07000B8L)

//
// MessageId: TLR_E_SIII_MA_CP_CONNECTION_SETUP_NOT_IN_CONFIGURATION
//
// MessageText:
//
//  Connection setup is not in configuration.
//
#define TLR_E_SIII_MA_CP_CONNECTION_SETUP_NOT_IN_CONFIGURATION ((TLR_RESULT)0xC07000B9L)

//
// MessageId: TLR_E_SIII_MA_CP_MINIMUM_CYCLE_TIME_CANNOT_BE_CALCULATED
//
// MessageText:
//
//  Minimum cycle time cannot be calculated.
//
#define TLR_E_SIII_MA_CP_MINIMUM_CYCLE_TIME_CANNOT_BE_CALCULATED ((TLR_RESULT)0xC07000BAL)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_WRONG_NODE_IN_LIST
//
// MessageText:
//
//  Internal topology information broken (Wrong node in list).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_WRONG_NODE_IN_LIST ((TLR_RESULT)0xC07000BBL)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_INVALID_LIST_HEAD_PRIMARY
//
// MessageText:
//
//  Internal topology information broken (Invalid list head on primary port).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_INVALID_LIST_HEAD_PRIMARY ((TLR_RESULT)0xC07000BCL)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_INVALID_LIST_TAIL_PRIMARY
//
// MessageText:
//
//  Internal topology information broken (Invalid list tail on primary port).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_INVALID_LIST_TAIL_PRIMARY ((TLR_RESULT)0xC07000BDL)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_INVALID_LIST_HEAD_SECONDARY
//
// MessageText:
//
//  Internal topology information broken (Invalid list head on secondary port).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_INVALID_LIST_HEAD_SECONDARY ((TLR_RESULT)0xC07000BEL)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_INVALID_LIST_TAIL_SECONDARY
//
// MessageText:
//
//  Internal topology information broken (Invalid list tail on secondary port).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_INVALID_LIST_TAIL_SECONDARY ((TLR_RESULT)0xC07000BFL)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_INVALID_LIST_HEAD_RING
//
// MessageText:
//
//  Internal topology information broken (Invalid list head on ring).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_INVALID_LIST_HEAD_RING ((TLR_RESULT)0xC07000C0L)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_INVALID_LIST_TAIL_RING
//
// MessageText:
//
//  Internal topology information broken (Invalid list tail on ring).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_INVALID_LIST_TAIL_RING ((TLR_RESULT)0xC07000C1L)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_HALF_MERGED
//
// MessageText:
//
//  Internal topology information broken (Half merged list).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_HALF_MERGED ((TLR_RESULT)0xC07000C2L)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_UNEXPECTED_NULL_POINTER_HEAD_PRIMARY
//
// MessageText:
//
//  Internal topology information broken (Unexpected null pointer on primary port head).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_UNEXPECTED_NULL_POINTER_HEAD_PRIMARY ((TLR_RESULT)0xC07000C3L)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_UNEXPECTED_NULL_POINTER_TAIL_PRIMARY
//
// MessageText:
//
//  Internal topology information broken (Unexpected null pointer on primary port tail).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_UNEXPECTED_NULL_POINTER_TAIL_PRIMARY ((TLR_RESULT)0xC07000C4L)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_UNEXPECTED_NULL_POINTER_HEAD_SECONDARY
//
// MessageText:
//
//  Internal topology information broken (Unexpected null pointer on secondary port head).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_UNEXPECTED_NULL_POINTER_HEAD_SECONDARY ((TLR_RESULT)0xC07000C5L)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_UNEXPECTED_NULL_POINTER_TAIL_SECONDARY
//
// MessageText:
//
//  Internal topology information broken (Unexpected null pointer on secondary port tail).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_UNEXPECTED_NULL_POINTER_TAIL_SECONDARY ((TLR_RESULT)0xC07000C6L)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_UNEXPECTED_NULL_POINTER_HEAD_RING
//
// MessageText:
//
//  Internal topology information broken (Unexpected null pointer on ring head).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_UNEXPECTED_NULL_POINTER_HEAD_RING ((TLR_RESULT)0xC07000C7L)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_UNEXPECTED_NULL_POINTER_TAIL_RING
//
// MessageText:
//
//  Internal topology information broken (Unexpected null pointer on ring tail).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_UNEXPECTED_NULL_POINTER_TAIL_RING ((TLR_RESULT)0xC07000C8L)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_CIRCULAR_DEFECT_PRIMARY
//
// MessageText:
//
//  Internal topology information broken (circular defect, primary port).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_CIRCULAR_DEFECT_PRIMARY ((TLR_RESULT)0xC07000C9L)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_CIRCULAR_DEFECT_SECONDARY
//
// MessageText:
//
//  Internal topology information broken (circular defect, secondary port).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_CIRCULAR_DEFECT_SECONDARY ((TLR_RESULT)0xC07000CAL)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_CIRCULAR_DEFECT_RING
//
// MessageText:
//
//  Internal topology information broken (circular defect, ring).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_CIRCULAR_DEFECT_RING ((TLR_RESULT)0xC07000CBL)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_RING_LIST_NOT_ENDING_ON_TAIL
//
// MessageText:
//
//  Internal topology information broken (ring list does not end on tail).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_RING_LIST_NOT_ENDING_ON_TAIL ((TLR_RESULT)0xC07000CCL)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_PRIMARY_LIST_NOT_ENDING_ON_TAIL
//
// MessageText:
//
//  Internal topology information broken (primary list does not end on tail).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_PRIMARY_LIST_NOT_ENDING_ON_TAIL ((TLR_RESULT)0xC07000CDL)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_SECONDARY_LIST_NOT_ENDING_ON_TAIL
//
// MessageText:
//
//  Internal topology information broken (secondary list does not end on tail).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_SECONDARY_LIST_NOT_ENDING_ON_TAIL ((TLR_RESULT)0xC07000CEL)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_NODE_LINKED_TO_BOTH_LISTS
//
// MessageText:
//
//  Internal topology information broken (Node linked to both lists).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_NODE_LINKED_TO_BOTH_LISTS ((TLR_RESULT)0xC07000CFL)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_UNKNOWN_TOPOLOGY_VARIANT
//
// MessageText:
//
//  Internal topology information broken (Unknown topology variant).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_UNKNOWN_TOPOLOGY_VARIANT ((TLR_RESULT)0xC07000D0L)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_NODE_IN_TOPOLOGY_FLAG_NOT_SET
//
// MessageText:
//
//  Internal topology information broken (Node in topology flag not set).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_NODE_IN_TOPOLOGY_FLAG_NOT_SET ((TLR_RESULT)0xC07000D1L)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_ADD_NODE_NOT_POSSIBLE_ON_RING
//
// MessageText:
//
//  Internal topology information broken (Add Node not possible on ring).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_ADD_NODE_NOT_POSSIBLE_ON_RING ((TLR_RESULT)0xC07000D2L)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_NODE_IN_TOPOLOGY_FLAG_ALREADY_SET
//
// MessageText:
//
//  Internal topology information broken (Node in topology flag already set).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_NODE_IN_TOPOLOGY_FLAG_ALREADY_SET ((TLR_RESULT)0xC07000D3L)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_INVALID_NODE_SPECIFIED
//
// MessageText:
//
//  Internal topology information broken (Invalid node specified).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_INVALID_NODE_SPECIFIED ((TLR_RESULT)0xC07000D4L)

//
// MessageId: TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_SPECIFIED_NODE_NOT_IN_TOPOLOGY
//
// MessageText:
//
//  Internal topology information broken (Specified Node not in topology).
//
#define TLR_E_SIII_MA_CP_INTERNAL_TOPOLOGY_INFORMATION_BROKEN_SPECIFIED_NODE_NOT_IN_TOPOLOGY ((TLR_RESULT)0xC07000D5L)

//
// MessageId: TLR_E_SIII_MA_CP_INVALID_NRT_MTU_SPECIFIED
//
// MessageText:
//
//  Invalid NRT MTU specified in configuration.
//
#define TLR_E_SIII_MA_CP_INVALID_NRT_MTU_SPECIFIED ((TLR_RESULT)0xC07000D6L)

//
// MessageId: TLR_E_SIII_MA_CP_SLAVE_ADDRESS_ALREADY_IN_DEVICE
//
// MessageText:
//
//  Slave address already configured in device relation.
//
#define TLR_E_SIII_MA_CP_SLAVE_ADDRESS_ALREADY_IN_DEVICE ((TLR_RESULT)0xC07000D7L)

//
// MessageId: TLR_E_SIII_MA_CP_TOO_MANY_SLAVES_CONFIGURED_IN_DEVICE
//
// MessageText:
//
//  Too many slaves configured in device.
//
#define TLR_E_SIII_MA_CP_TOO_MANY_SLAVES_CONFIGURED_IN_DEVICE ((TLR_RESULT)0xC07000D8L)

//
// MessageId: TLR_E_SIII_MA_CP_INVALID_FIRST_ENTRY
//
// MessageText:
//
//  Invalid first entry.
//
#define TLR_E_SIII_MA_CP_INVALID_FIRST_ENTRY ((TLR_RESULT)0xC07000D9L)

//
// MessageId: TLR_E_SIII_MA_CP_CONNECTION_INSTANCE_ALREADY_IN_CONFIGURATION
//
// MessageText:
//
//  Connection instance already in configuration.
//
#define TLR_E_SIII_MA_CP_CONNECTION_INSTANCE_ALREADY_IN_CONFIGURATION ((TLR_RESULT)0xC07000DAL)

//
// MessageId: TLR_E_SIII_MA_CP_SCP_SYSTIME_CTRL_STAT_CONFIG_INCOMPLETE
//
// MessageText:
//
//  Incomplete SCP_SysTime Control/Status configuration.
//
#define TLR_E_SIII_MA_CP_SCP_SYSTIME_CTRL_STAT_CONFIG_INCOMPLETE ((TLR_RESULT)0xC07000DBL)

//
// MessageId: TLR_E_SIII_MA_CP_INVALID_CONN_DPM_CONNCTRL_OFFSET
//
// MessageText:
//
//  Invalid connection DPM Connection Control Offset.
//
#define TLR_E_SIII_MA_CP_INVALID_CONN_DPM_CONNCTRL_OFFSET ((TLR_RESULT)0xC07000DCL)

//
// MessageId: TLR_E_SIII_MA_CP_INVALID_CONN_DPM_RTDATA_OFFSET
//
// MessageText:
//
//  Invalid connection DPM RtData offset.
//
#define TLR_E_SIII_MA_CP_INVALID_CONN_DPM_RTDATA_OFFSET ((TLR_RESULT)0xC07000DDL)

//
// MessageId: TLR_E_SIII_MA_CP_INVALID_CONNECTION_LENGTH
//
// MessageText:
//
//  Invalid connection length.
//
#define TLR_E_SIII_MA_CP_INVALID_CONNECTION_LENGTH ((TLR_RESULT)0xC07000DEL)

//
// MessageId: TLR_E_SIII_MA_CP_NOT_POSSIBLE_ON_REOPENED_CONFIG
//
// MessageText:
//
//  Not possible on re-opened configuration.
//
#define TLR_E_SIII_MA_CP_NOT_POSSIBLE_ON_REOPENED_CONFIG ((TLR_RESULT)0xC07000DFL)

//
// MessageId: TLR_E_SIII_MA_CP_INVALID_INITCMD_IDX
//
// MessageText:
//
//  Invalid InitCmd index.
//
#define TLR_E_SIII_MA_CP_INVALID_INITCMD_IDX ((TLR_RESULT)0xC07000E0L)

//
// MessageId: TLR_E_SIII_MA_CP_DUPLICATE_INITCMD_LABEL
//
// MessageText:
//
//  Duplicate InitCmd Label.
//
#define TLR_E_SIII_MA_CP_DUPLICATE_INITCMD_LABEL ((TLR_RESULT)0xC07000E1L)

//
// MessageId: TLR_E_SIII_MA_CP_INITCMD_JUMP_LOGIC_NOT_COMPILED_IN
//
// MessageText:
//
//  InitCmd Jump logic not compiled into stack.
//
#define TLR_E_SIII_MA_CP_INITCMD_JUMP_LOGIC_NOT_COMPILED_IN ((TLR_RESULT)0xC07000E2L)




#endif  //__SERCOSIII_MA_CP_ERROR_H

